/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.menu;

import com.jhe.hexed.JHexEditorData;
import emulator.cbm.Petscii;
import emulator.shell.GUI.debugger.CodeInfo;
import emulator.util.AddressRange;

public class MemoryQuery {
    private JHexEditorData _data;
    private String _text;
    private int _position;
    private CodeInfo _codeInfo;

    public MemoryQuery(JHexEditorData data, String search_text, CodeInfo code_info) {
        this._data = data;
        this._text = search_text;
        this._codeInfo = code_info;
        this._position = -1;
    }

    public boolean execute() {
        if (this._text.length() == 0) {
            return false;
        }
        if (this._text.charAt(0) == '=' && this._text.length() > 1) {
            if (this._text.charAt(1) == '\"') {
                int end = this._text.indexOf(34, 2);
                if (end < 0) {
                    end = this._text.length();
                }
                byte[] values = new byte[end - 2];
                int i = 0;
                while (i < values.length) {
                    values[i] = Petscii.asc2pet(this._text.charAt(i + 2));
                    ++i;
                }
                return this.find(values);
            }
            String[] value_parts = this._text.substring(1).split("\\s+");
            try {
                if (value_parts.length > 0) {
                    byte[] values = new byte[value_parts.length];
                    int i = 0;
                    while (i < value_parts.length) {
                        values[i] = (byte)(AddressRange.addressFromString(value_parts[i]) & 0xFF);
                        ++i;
                    }
                    return this.find(values);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return false;
        }
        return this.searchAddressOrLabel(this._text);
    }

    private boolean find(byte[] values) {
        this._position = this._data.find(values, this._position + 1);
        return this._position >= 0;
    }

    private boolean searchAddressOrLabel(String search_text) {
        int address = -1;
        try {
            address = AddressRange.addressFromString(search_text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (address < 0 && this._data.isAtOrigin()) {
                address = this._codeInfo.findLabel(search_text);
            }
            this._position = address;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getPosition() {
        return this._position;
    }
}

